// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    internal static partial class DataLakeAnalyticsCommitmentTierTypeExtensions
    {
        public static string ToSerialString(this DataLakeAnalyticsCommitmentTierType value) => value switch
        {
            DataLakeAnalyticsCommitmentTierType.Consumption => "Consumption",
            DataLakeAnalyticsCommitmentTierType.Commitment100AUHours => "Commitment_100AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment500AUHours => "Commitment_500AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment1000AUHours => "Commitment_1000AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment5000AUHours => "Commitment_5000AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment10000AUHours => "Commitment_10000AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment50000AUHours => "Commitment_50000AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment100000AUHours => "Commitment_100000AUHours",
            DataLakeAnalyticsCommitmentTierType.Commitment500000AUHours => "Commitment_500000AUHours",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsCommitmentTierType value.")
        };

        public static DataLakeAnalyticsCommitmentTierType ToDataLakeAnalyticsCommitmentTierType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Consumption")) return DataLakeAnalyticsCommitmentTierType.Consumption;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_100AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment100AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_500AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment500AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_1000AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment1000AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_5000AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment5000AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_10000AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment10000AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_50000AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment50000AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_100000AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment100000AUHours;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Commitment_500000AUHours")) return DataLakeAnalyticsCommitmentTierType.Commitment500000AUHours;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsCommitmentTierType value.");
        }
    }
}
