// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// Subscription-level properties and limits for Data Lake Analytics.
    /// Serialized Name: CapabilityInformation
    /// </summary>
    public partial class DataLakeAnalyticsCapabilityInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsCapabilityInformation"/>. </summary>
        internal DataLakeAnalyticsCapabilityInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsCapabilityInformation"/>. </summary>
        /// <param name="subscriptionId">
        /// The subscription credentials that uniquely identifies the subscription.
        /// Serialized Name: CapabilityInformation.subscriptionId
        /// </param>
        /// <param name="state">
        /// The subscription state.
        /// Serialized Name: CapabilityInformation.state
        /// </param>
        /// <param name="maxAccountCount">
        /// The maximum supported number of accounts under this subscription.
        /// Serialized Name: CapabilityInformation.maxAccountCount
        /// </param>
        /// <param name="accountCount">
        /// The current number of accounts under this subscription.
        /// Serialized Name: CapabilityInformation.accountCount
        /// </param>
        /// <param name="isUnderMigrationState">
        /// The Boolean value of true or false to indicate the maintenance state.
        /// Serialized Name: CapabilityInformation.migrationState
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeAnalyticsCapabilityInformation(Guid? subscriptionId, DataLakeAnalyticsSubscriptionState? state, int? maxAccountCount, int? accountCount, bool? isUnderMigrationState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubscriptionId = subscriptionId;
            State = state;
            MaxAccountCount = maxAccountCount;
            AccountCount = accountCount;
            IsUnderMigrationState = isUnderMigrationState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The subscription credentials that uniquely identifies the subscription.
        /// Serialized Name: CapabilityInformation.subscriptionId
        /// </summary>
        public Guid? SubscriptionId { get; }
        /// <summary>
        /// The subscription state.
        /// Serialized Name: CapabilityInformation.state
        /// </summary>
        public DataLakeAnalyticsSubscriptionState? State { get; }
        /// <summary>
        /// The maximum supported number of accounts under this subscription.
        /// Serialized Name: CapabilityInformation.maxAccountCount
        /// </summary>
        public int? MaxAccountCount { get; }
        /// <summary>
        /// The current number of accounts under this subscription.
        /// Serialized Name: CapabilityInformation.accountCount
        /// </summary>
        public int? AccountCount { get; }
        /// <summary>
        /// The Boolean value of true or false to indicate the maintenance state.
        /// Serialized Name: CapabilityInformation.migrationState
        /// </summary>
        public bool? IsUnderMigrationState { get; }
    }
}
