// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    internal static partial class DataLakeAnalyticsAccountStatusExtensions
    {
        public static string ToSerialString(this DataLakeAnalyticsAccountStatus value) => value switch
        {
            DataLakeAnalyticsAccountStatus.Failed => "Failed",
            DataLakeAnalyticsAccountStatus.Creating => "Creating",
            DataLakeAnalyticsAccountStatus.Running => "Running",
            DataLakeAnalyticsAccountStatus.Succeeded => "Succeeded",
            DataLakeAnalyticsAccountStatus.Patching => "Patching",
            DataLakeAnalyticsAccountStatus.Suspending => "Suspending",
            DataLakeAnalyticsAccountStatus.Resuming => "Resuming",
            DataLakeAnalyticsAccountStatus.Deleting => "Deleting",
            DataLakeAnalyticsAccountStatus.Deleted => "Deleted",
            DataLakeAnalyticsAccountStatus.Undeleting => "Undeleting",
            DataLakeAnalyticsAccountStatus.Canceled => "Canceled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsAccountStatus value.")
        };

        public static DataLakeAnalyticsAccountStatus ToDataLakeAnalyticsAccountStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return DataLakeAnalyticsAccountStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return DataLakeAnalyticsAccountStatus.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Running")) return DataLakeAnalyticsAccountStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return DataLakeAnalyticsAccountStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Patching")) return DataLakeAnalyticsAccountStatus.Patching;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Suspending")) return DataLakeAnalyticsAccountStatus.Suspending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Resuming")) return DataLakeAnalyticsAccountStatus.Resuming;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return DataLakeAnalyticsAccountStatus.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleted")) return DataLakeAnalyticsAccountStatus.Deleted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Undeleting")) return DataLakeAnalyticsAccountStatus.Undeleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Canceled")) return DataLakeAnalyticsAccountStatus.Canceled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsAccountStatus value.");
        }
    }
}
