// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    internal static partial class DataLakeAnalyticsAccountStateExtensions
    {
        public static string ToSerialString(this DataLakeAnalyticsAccountState value) => value switch
        {
            DataLakeAnalyticsAccountState.Active => "Active",
            DataLakeAnalyticsAccountState.Suspended => "Suspended",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsAccountState value.")
        };

        public static DataLakeAnalyticsAccountState ToDataLakeAnalyticsAccountState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Active")) return DataLakeAnalyticsAccountState.Active;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Suspended")) return DataLakeAnalyticsAccountState.Suspended;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsAccountState value.");
        }
    }
}
