// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// Data Lake Analytics account name availability result information.
    /// Serialized Name: NameAvailabilityInformation
    /// </summary>
    public partial class DataLakeAnalyticsAccountNameAvailabilityResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsAccountNameAvailabilityResult"/>. </summary>
        internal DataLakeAnalyticsAccountNameAvailabilityResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsAccountNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable">
        /// The Boolean value of true or false to indicate whether the Data Lake Analytics account name is available or not.
        /// Serialized Name: NameAvailabilityInformation.nameAvailable
        /// </param>
        /// <param name="reason">
        /// The reason why the Data Lake Analytics account name is not available, if nameAvailable is false.
        /// Serialized Name: NameAvailabilityInformation.reason
        /// </param>
        /// <param name="message">
        /// The message describing why the Data Lake Analytics account name is not available, if nameAvailable is false.
        /// Serialized Name: NameAvailabilityInformation.message
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeAnalyticsAccountNameAvailabilityResult(bool? isNameAvailable, string reason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsNameAvailable = isNameAvailable;
            Reason = reason;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The Boolean value of true or false to indicate whether the Data Lake Analytics account name is available or not.
        /// Serialized Name: NameAvailabilityInformation.nameAvailable
        /// </summary>
        public bool? IsNameAvailable { get; }
        /// <summary>
        /// The reason why the Data Lake Analytics account name is not available, if nameAvailable is false.
        /// Serialized Name: NameAvailabilityInformation.reason
        /// </summary>
        public string Reason { get; }
        /// <summary>
        /// The message describing why the Data Lake Analytics account name is not available, if nameAvailable is false.
        /// Serialized Name: NameAvailabilityInformation.message
        /// </summary>
        public string Message { get; }
    }
}
