// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// Data Lake Analytics account list information.
    /// Serialized Name: DataLakeAnalyticsAccountListResult
    /// </summary>
    internal partial class DataLakeAnalyticsAccountListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsAccountListResult"/>. </summary>
        internal DataLakeAnalyticsAccountListResult()
        {
            Value = new ChangeTrackingList<DataLakeAnalyticsAccountBasic>();
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsAccountListResult"/>. </summary>
        /// <param name="value">
        /// The results of the list operation.
        /// Serialized Name: DataLakeAnalyticsAccountListResult.value
        /// </param>
        /// <param name="count">
        /// The current number of data lake analytics accounts under this subscription.
        /// Serialized Name: DataLakeAnalyticsAccountListResult.count
        /// </param>
        /// <param name="nextLink">
        /// The link (url) to the next page of results.
        /// Serialized Name: DataLakeAnalyticsAccountListResult.nextLink
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeAnalyticsAccountListResult(IReadOnlyList<DataLakeAnalyticsAccountBasic> value, int? count, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            Count = count;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The results of the list operation.
        /// Serialized Name: DataLakeAnalyticsAccountListResult.value
        /// </summary>
        public IReadOnlyList<DataLakeAnalyticsAccountBasic> Value { get; }
        /// <summary>
        /// The current number of data lake analytics accounts under this subscription.
        /// Serialized Name: DataLakeAnalyticsAccountListResult.count
        /// </summary>
        public int? Count { get; }
        /// <summary>
        /// The link (url) to the next page of results.
        /// Serialized Name: DataLakeAnalyticsAccountListResult.nextLink
        /// </summary>
        public string NextLink { get; }
    }
}
