// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataLakeAnalytics
{
    internal class DataLakeAnalyticsAccountOperationSource : IOperationSource<DataLakeAnalyticsAccountResource>
    {
        private readonly ArmClient _client;

        internal DataLakeAnalyticsAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataLakeAnalyticsAccountResource IOperationSource<DataLakeAnalyticsAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataLakeAnalyticsAccountData.DeserializeDataLakeAnalyticsAccountData(document.RootElement);
            return new DataLakeAnalyticsAccountResource(_client, data);
        }

        async ValueTask<DataLakeAnalyticsAccountResource> IOperationSource<DataLakeAnalyticsAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataLakeAnalyticsAccountData.DeserializeDataLakeAnalyticsAccountData(document.RootElement);
            return new DataLakeAnalyticsAccountResource(_client, data);
        }
    }
}
