// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataLakeAnalytics.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataLakeAnalytics
{
    /// <summary>
    /// A class representing the DataLakeAnalyticsComputePolicy data model.
    /// Data Lake Analytics compute policy information.
    /// Serialized Name: ComputePolicy
    /// </summary>
    public partial class DataLakeAnalyticsComputePolicyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsComputePolicyData"/>. </summary>
        internal DataLakeAnalyticsComputePolicyData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsComputePolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="objectId">
        /// The AAD object identifier for the entity to create a policy for.
        /// Serialized Name: ComputePolicy.properties.objectId
        /// </param>
        /// <param name="objectType">
        /// The type of AAD object the object identifier refers to.
        /// Serialized Name: ComputePolicy.properties.objectType
        /// </param>
        /// <param name="maxDegreeOfParallelismPerJob">
        /// The maximum degree of parallelism per job this user can use to submit jobs.
        /// Serialized Name: ComputePolicy.properties.maxDegreeOfParallelismPerJob
        /// </param>
        /// <param name="minPriorityPerJob">
        /// The minimum priority per job this user can use to submit jobs.
        /// Serialized Name: ComputePolicy.properties.minPriorityPerJob
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeAnalyticsComputePolicyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, Guid? objectId, AadObjectIdentifierType? objectType, int? maxDegreeOfParallelismPerJob, int? minPriorityPerJob, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ObjectId = objectId;
            ObjectType = objectType;
            MaxDegreeOfParallelismPerJob = maxDegreeOfParallelismPerJob;
            MinPriorityPerJob = minPriorityPerJob;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The AAD object identifier for the entity to create a policy for.
        /// Serialized Name: ComputePolicy.properties.objectId
        /// </summary>
        public Guid? ObjectId { get; }
        /// <summary>
        /// The type of AAD object the object identifier refers to.
        /// Serialized Name: ComputePolicy.properties.objectType
        /// </summary>
        public AadObjectIdentifierType? ObjectType { get; }
        /// <summary>
        /// The maximum degree of parallelism per job this user can use to submit jobs.
        /// Serialized Name: ComputePolicy.properties.maxDegreeOfParallelismPerJob
        /// </summary>
        public int? MaxDegreeOfParallelismPerJob { get; }
        /// <summary>
        /// The minimum priority per job this user can use to submit jobs.
        /// Serialized Name: ComputePolicy.properties.minPriorityPerJob
        /// </summary>
        public int? MinPriorityPerJob { get; }
    }
}
