// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataLakeAnalytics.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataLakeAnalytics
{
    /// <summary>
    /// A class representing the DataLakeAnalyticsAccount data model.
    /// A Data Lake Analytics account object, containing all information associated with the named Data Lake Analytics account.
    /// Serialized Name: DataLakeAnalyticsAccount
    /// </summary>
    public partial class DataLakeAnalyticsAccountData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsAccountData"/>. </summary>
        internal DataLakeAnalyticsAccountData()
        {
            DataLakeStoreAccounts = new ChangeTrackingList<DataLakeStoreAccountInformationData>();
            PublicDataLakeStoreAccounts = new ChangeTrackingList<DataLakeStoreAccountInformationData>();
            StorageAccounts = new ChangeTrackingList<DataLakeAnalyticsStorageAccountInformationData>();
            ComputePolicies = new ChangeTrackingList<DataLakeAnalyticsComputePolicyData>();
            HiveMetastores = new ChangeTrackingList<DataLakeAnalyticsHiveMetastore>();
            VirtualNetworkRules = new ChangeTrackingList<DataLakeAnalyticsVirtualNetworkRule>();
            FirewallRules = new ChangeTrackingList<DataLakeAnalyticsFirewallRuleData>();
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="accountId">
        /// The unique identifier associated with this Data Lake Analytics account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.accountId
        /// </param>
        /// <param name="provisioningState">
        /// The provisioning status of the Data Lake Analytics account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.provisioningState
        /// </param>
        /// <param name="state">
        /// The state of the Data Lake Analytics account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.state
        /// </param>
        /// <param name="createdOn">
        /// The account creation time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.creationTime
        /// </param>
        /// <param name="lastModifiedOn">
        /// The account last modified time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.lastModifiedTime
        /// </param>
        /// <param name="endpoint">
        /// The full CName endpoint for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.endpoint
        /// </param>
        /// <param name="defaultDataLakeStoreAccount">
        /// The default Data Lake Store account associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.defaultDataLakeStoreAccount
        /// </param>
        /// <param name="dataLakeStoreAccounts">
        /// The list of Data Lake Store accounts associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.dataLakeStoreAccounts
        /// </param>
        /// <param name="publicDataLakeStoreAccounts">
        /// The list of Data Lake Store accounts associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.publicDataLakeStoreAccounts
        /// </param>
        /// <param name="storageAccounts">
        /// The list of Azure Blob Storage accounts associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.storageAccounts
        /// </param>
        /// <param name="computePolicies">
        /// The list of compute policies associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.computePolicies
        /// </param>
        /// <param name="hiveMetastores">
        /// The list of hiveMetastores associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.hiveMetastores
        /// </param>
        /// <param name="virtualNetworkRules">
        /// The list of virtualNetwork rules associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.virtualNetworkRules
        /// </param>
        /// <param name="firewallRules">
        /// The list of firewall rules associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.firewallRules
        /// </param>
        /// <param name="firewallState">
        /// The current state of the IP address firewall for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.firewallState
        /// </param>
        /// <param name="firewallAllowAzureIPs">
        /// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.firewallAllowAzureIps
        /// </param>
        /// <param name="newTier">
        /// The commitment tier for the next month.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.newTier
        /// </param>
        /// <param name="currentTier">
        /// The commitment tier in use for the current month.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.currentTier
        /// </param>
        /// <param name="maxJobCount">
        /// The maximum supported jobs running under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxJobCount
        /// </param>
        /// <param name="maxActiveJobCountPerUser">
        /// The maximum supported active jobs under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxActiveJobCountPerUser
        /// </param>
        /// <param name="maxQueuedJobCountPerUser">
        /// The maximum supported jobs queued under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxQueuedJobCountPerUser
        /// </param>
        /// <param name="maxJobRunningTimeInMin">
        /// The maximum supported active jobs under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxJobRunningTimeInMin
        /// </param>
        /// <param name="systemMaxJobCount">
        /// The system defined maximum supported jobs running under the account at the same time, which restricts the maximum number of running jobs the user can set for the account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.systemMaxJobCount
        /// </param>
        /// <param name="maxDegreeOfParallelism">
        /// The maximum supported degree of parallelism for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxDegreeOfParallelism
        /// </param>
        /// <param name="systemMaxDegreeOfParallelism">
        /// The system defined maximum supported degree of parallelism for this account, which restricts the maximum value of parallelism the user can set for the account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.systemMaxDegreeOfParallelism
        /// </param>
        /// <param name="maxDegreeOfParallelismPerJob">
        /// The maximum supported degree of parallelism per job for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxDegreeOfParallelismPerJob
        /// </param>
        /// <param name="minPriorityPerJob">
        /// The minimum supported priority per job for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.minPriorityPerJob
        /// </param>
        /// <param name="queryStoreRetention">
        /// The number of days that job metadata is retained.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.queryStoreRetention
        /// </param>
        /// <param name="debugDataAccessLevel">
        /// The current state of the DebugDataAccessLevel for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.debugDataAccessLevel
        /// </param>
        /// <param name="location">
        /// The resource location.
        /// Serialized Name: Resource.location
        /// </param>
        /// <param name="tags">
        /// The resource tags.
        /// Serialized Name: Resource.tags
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeAnalyticsAccountData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, Guid? accountId, DataLakeAnalyticsAccountStatus? provisioningState, DataLakeAnalyticsAccountState? state, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, string endpoint, string defaultDataLakeStoreAccount, IReadOnlyList<DataLakeStoreAccountInformationData> dataLakeStoreAccounts, IReadOnlyList<DataLakeStoreAccountInformationData> publicDataLakeStoreAccounts, IReadOnlyList<DataLakeAnalyticsStorageAccountInformationData> storageAccounts, IReadOnlyList<DataLakeAnalyticsComputePolicyData> computePolicies, IReadOnlyList<DataLakeAnalyticsHiveMetastore> hiveMetastores, IReadOnlyList<DataLakeAnalyticsVirtualNetworkRule> virtualNetworkRules, IReadOnlyList<DataLakeAnalyticsFirewallRuleData> firewallRules, DataLakeAnalyticsFirewallState? firewallState, DataLakeAnalyticsFirewallAllowAzureIPsState? firewallAllowAzureIPs, DataLakeAnalyticsCommitmentTierType? newTier, DataLakeAnalyticsCommitmentTierType? currentTier, int? maxJobCount, int? maxActiveJobCountPerUser, int? maxQueuedJobCountPerUser, int? maxJobRunningTimeInMin, int? systemMaxJobCount, int? maxDegreeOfParallelism, int? systemMaxDegreeOfParallelism, int? maxDegreeOfParallelismPerJob, int? minPriorityPerJob, int? queryStoreRetention, DebugDataAccessLevel? debugDataAccessLevel, AzureLocation? location, IReadOnlyDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AccountId = accountId;
            ProvisioningState = provisioningState;
            State = state;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            Endpoint = endpoint;
            DefaultDataLakeStoreAccount = defaultDataLakeStoreAccount;
            DataLakeStoreAccounts = dataLakeStoreAccounts;
            PublicDataLakeStoreAccounts = publicDataLakeStoreAccounts;
            StorageAccounts = storageAccounts;
            ComputePolicies = computePolicies;
            HiveMetastores = hiveMetastores;
            VirtualNetworkRules = virtualNetworkRules;
            FirewallRules = firewallRules;
            FirewallState = firewallState;
            FirewallAllowAzureIPs = firewallAllowAzureIPs;
            NewTier = newTier;
            CurrentTier = currentTier;
            MaxJobCount = maxJobCount;
            MaxActiveJobCountPerUser = maxActiveJobCountPerUser;
            MaxQueuedJobCountPerUser = maxQueuedJobCountPerUser;
            MaxJobRunningTimeInMin = maxJobRunningTimeInMin;
            SystemMaxJobCount = systemMaxJobCount;
            MaxDegreeOfParallelism = maxDegreeOfParallelism;
            SystemMaxDegreeOfParallelism = systemMaxDegreeOfParallelism;
            MaxDegreeOfParallelismPerJob = maxDegreeOfParallelismPerJob;
            MinPriorityPerJob = minPriorityPerJob;
            QueryStoreRetention = queryStoreRetention;
            DebugDataAccessLevel = debugDataAccessLevel;
            Location = location;
            Tags = tags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The unique identifier associated with this Data Lake Analytics account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.accountId
        /// </summary>
        public Guid? AccountId { get; }
        /// <summary>
        /// The provisioning status of the Data Lake Analytics account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.provisioningState
        /// </summary>
        public DataLakeAnalyticsAccountStatus? ProvisioningState { get; }
        /// <summary>
        /// The state of the Data Lake Analytics account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.state
        /// </summary>
        public DataLakeAnalyticsAccountState? State { get; }
        /// <summary>
        /// The account creation time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.creationTime
        /// </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary>
        /// The account last modified time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.lastModifiedTime
        /// </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary>
        /// The full CName endpoint for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.endpoint
        /// </summary>
        public string Endpoint { get; }
        /// <summary>
        /// The default Data Lake Store account associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.defaultDataLakeStoreAccount
        /// </summary>
        public string DefaultDataLakeStoreAccount { get; }
        /// <summary>
        /// The list of Data Lake Store accounts associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.dataLakeStoreAccounts
        /// </summary>
        public IReadOnlyList<DataLakeStoreAccountInformationData> DataLakeStoreAccounts { get; }
        /// <summary>
        /// The list of Data Lake Store accounts associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.publicDataLakeStoreAccounts
        /// </summary>
        public IReadOnlyList<DataLakeStoreAccountInformationData> PublicDataLakeStoreAccounts { get; }
        /// <summary>
        /// The list of Azure Blob Storage accounts associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.storageAccounts
        /// </summary>
        public IReadOnlyList<DataLakeAnalyticsStorageAccountInformationData> StorageAccounts { get; }
        /// <summary>
        /// The list of compute policies associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.computePolicies
        /// </summary>
        public IReadOnlyList<DataLakeAnalyticsComputePolicyData> ComputePolicies { get; }
        /// <summary>
        /// The list of hiveMetastores associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.hiveMetastores
        /// </summary>
        public IReadOnlyList<DataLakeAnalyticsHiveMetastore> HiveMetastores { get; }
        /// <summary>
        /// The list of virtualNetwork rules associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.virtualNetworkRules
        /// </summary>
        public IReadOnlyList<DataLakeAnalyticsVirtualNetworkRule> VirtualNetworkRules { get; }
        /// <summary>
        /// The list of firewall rules associated with this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.firewallRules
        /// </summary>
        public IReadOnlyList<DataLakeAnalyticsFirewallRuleData> FirewallRules { get; }
        /// <summary>
        /// The current state of the IP address firewall for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.firewallState
        /// </summary>
        public DataLakeAnalyticsFirewallState? FirewallState { get; }
        /// <summary>
        /// The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.firewallAllowAzureIps
        /// </summary>
        public DataLakeAnalyticsFirewallAllowAzureIPsState? FirewallAllowAzureIPs { get; }
        /// <summary>
        /// The commitment tier for the next month.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.newTier
        /// </summary>
        public DataLakeAnalyticsCommitmentTierType? NewTier { get; }
        /// <summary>
        /// The commitment tier in use for the current month.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.currentTier
        /// </summary>
        public DataLakeAnalyticsCommitmentTierType? CurrentTier { get; }
        /// <summary>
        /// The maximum supported jobs running under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxJobCount
        /// </summary>
        public int? MaxJobCount { get; }
        /// <summary>
        /// The maximum supported active jobs under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxActiveJobCountPerUser
        /// </summary>
        public int? MaxActiveJobCountPerUser { get; }
        /// <summary>
        /// The maximum supported jobs queued under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxQueuedJobCountPerUser
        /// </summary>
        public int? MaxQueuedJobCountPerUser { get; }
        /// <summary>
        /// The maximum supported active jobs under the account at the same time.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxJobRunningTimeInMin
        /// </summary>
        public int? MaxJobRunningTimeInMin { get; }
        /// <summary>
        /// The system defined maximum supported jobs running under the account at the same time, which restricts the maximum number of running jobs the user can set for the account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.systemMaxJobCount
        /// </summary>
        public int? SystemMaxJobCount { get; }
        /// <summary>
        /// The maximum supported degree of parallelism for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxDegreeOfParallelism
        /// </summary>
        public int? MaxDegreeOfParallelism { get; }
        /// <summary>
        /// The system defined maximum supported degree of parallelism for this account, which restricts the maximum value of parallelism the user can set for the account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.systemMaxDegreeOfParallelism
        /// </summary>
        public int? SystemMaxDegreeOfParallelism { get; }
        /// <summary>
        /// The maximum supported degree of parallelism per job for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.maxDegreeOfParallelismPerJob
        /// </summary>
        public int? MaxDegreeOfParallelismPerJob { get; }
        /// <summary>
        /// The minimum supported priority per job for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.minPriorityPerJob
        /// </summary>
        public int? MinPriorityPerJob { get; }
        /// <summary>
        /// The number of days that job metadata is retained.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.queryStoreRetention
        /// </summary>
        public int? QueryStoreRetention { get; }
        /// <summary>
        /// The current state of the DebugDataAccessLevel for this account.
        /// Serialized Name: DataLakeAnalyticsAccount.properties.debugDataAccessLevel
        /// </summary>
        public DebugDataAccessLevel? DebugDataAccessLevel { get; }
        /// <summary>
        /// The resource location.
        /// Serialized Name: Resource.location
        /// </summary>
        public AzureLocation? Location { get; }
        /// <summary>
        /// The resource tags.
        /// Serialized Name: Resource.tags
        /// </summary>
        public IReadOnlyDictionary<string, string> Tags { get; }
    }
}
