// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataLakeAnalytics.Models;

namespace Azure.ResourceManager.DataLakeAnalytics.Samples
{
    public partial class Sample_DataLakeAnalyticsStorageContainerResource
    {
        // Gets the specified Azure Storage container
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheSpecifiedAzureStorageContainer()
        {
            // Generated from example definition: specification/datalake-analytics/resource-manager/Microsoft.DataLakeAnalytics/stable/2016-11-01/examples/StorageAccounts_GetStorageContainer.json
            // this example is just showing the usage of "StorageAccounts_GetStorageContainer" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataLakeAnalyticsStorageContainerResource created on azure
            // for more information of creating DataLakeAnalyticsStorageContainerResource, please refer to the document of DataLakeAnalyticsStorageContainerResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "contosorg";
            string accountName = "contosoadla";
            string storageAccountName = "test_storage";
            string containerName = "test_container";
            ResourceIdentifier dataLakeAnalyticsStorageContainerResourceId = DataLakeAnalyticsStorageContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, storageAccountName, containerName);
            DataLakeAnalyticsStorageContainerResource dataLakeAnalyticsStorageContainer = client.GetDataLakeAnalyticsStorageContainerResource(dataLakeAnalyticsStorageContainerResourceId);

            // invoke the operation
            DataLakeAnalyticsStorageContainerResource result = await dataLakeAnalyticsStorageContainer.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataLakeAnalyticsStorageContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets the SAS token
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSasTokens_GetsTheSASToken()
        {
            // Generated from example definition: specification/datalake-analytics/resource-manager/Microsoft.DataLakeAnalytics/stable/2016-11-01/examples/StorageAccounts_ListSasTokens.json
            // this example is just showing the usage of "StorageAccounts_ListSasTokens" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataLakeAnalyticsStorageContainerResource created on azure
            // for more information of creating DataLakeAnalyticsStorageContainerResource, please refer to the document of DataLakeAnalyticsStorageContainerResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "contosorg";
            string accountName = "contosoadla";
            string storageAccountName = "test_storage";
            string containerName = "test_container";
            ResourceIdentifier dataLakeAnalyticsStorageContainerResourceId = DataLakeAnalyticsStorageContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, storageAccountName, containerName);
            DataLakeAnalyticsStorageContainerResource dataLakeAnalyticsStorageContainer = client.GetDataLakeAnalyticsStorageContainerResource(dataLakeAnalyticsStorageContainerResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataLakeAnalyticsSasTokenInformation item in dataLakeAnalyticsStorageContainer.GetSasTokensAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
