// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataLakeAnalytics.Models;

namespace Azure.ResourceManager.DataLakeAnalytics.Samples
{
    public partial class Sample_DataLakeAnalyticsComputePolicyResource
    {
        // Gets the specified compute policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheSpecifiedComputePolicy()
        {
            // Generated from example definition: specification/datalake-analytics/resource-manager/Microsoft.DataLakeAnalytics/stable/2016-11-01/examples/ComputePolicies_Get.json
            // this example is just showing the usage of "ComputePolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataLakeAnalyticsComputePolicyResource created on azure
            // for more information of creating DataLakeAnalyticsComputePolicyResource, please refer to the document of DataLakeAnalyticsComputePolicyResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "contosorg";
            string accountName = "contosoadla";
            string computePolicyName = "test_policy";
            ResourceIdentifier dataLakeAnalyticsComputePolicyResourceId = DataLakeAnalyticsComputePolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, computePolicyName);
            DataLakeAnalyticsComputePolicyResource dataLakeAnalyticsComputePolicy = client.GetDataLakeAnalyticsComputePolicyResource(dataLakeAnalyticsComputePolicyResourceId);

            // invoke the operation
            DataLakeAnalyticsComputePolicyResource result = await dataLakeAnalyticsComputePolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataLakeAnalyticsComputePolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates the specified compute policy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesTheSpecifiedComputePolicy()
        {
            // Generated from example definition: specification/datalake-analytics/resource-manager/Microsoft.DataLakeAnalytics/stable/2016-11-01/examples/ComputePolicies_Update.json
            // this example is just showing the usage of "ComputePolicies_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataLakeAnalyticsComputePolicyResource created on azure
            // for more information of creating DataLakeAnalyticsComputePolicyResource, please refer to the document of DataLakeAnalyticsComputePolicyResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "contosorg";
            string accountName = "contosoadla";
            string computePolicyName = "test_policy";
            ResourceIdentifier dataLakeAnalyticsComputePolicyResourceId = DataLakeAnalyticsComputePolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, computePolicyName);
            DataLakeAnalyticsComputePolicyResource dataLakeAnalyticsComputePolicy = client.GetDataLakeAnalyticsComputePolicyResource(dataLakeAnalyticsComputePolicyResourceId);

            // invoke the operation
            DataLakeAnalyticsComputePolicyPatch patch = new DataLakeAnalyticsComputePolicyPatch()
            {
                MaxDegreeOfParallelismPerJob = 11,
                MinPriorityPerJob = 31,
            };
            DataLakeAnalyticsComputePolicyResource result = await dataLakeAnalyticsComputePolicy.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataLakeAnalyticsComputePolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes the specified compute policy from the adla account
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesTheSpecifiedComputePolicyFromTheAdlaAccount()
        {
            // Generated from example definition: specification/datalake-analytics/resource-manager/Microsoft.DataLakeAnalytics/stable/2016-11-01/examples/ComputePolicies_Delete.json
            // this example is just showing the usage of "ComputePolicies_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataLakeAnalyticsComputePolicyResource created on azure
            // for more information of creating DataLakeAnalyticsComputePolicyResource, please refer to the document of DataLakeAnalyticsComputePolicyResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "contosorg";
            string accountName = "contosoadla";
            string computePolicyName = "test_policy";
            ResourceIdentifier dataLakeAnalyticsComputePolicyResourceId = DataLakeAnalyticsComputePolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, computePolicyName);
            DataLakeAnalyticsComputePolicyResource dataLakeAnalyticsComputePolicy = client.GetDataLakeAnalyticsComputePolicyResource(dataLakeAnalyticsComputePolicyResourceId);

            // invoke the operation
            await dataLakeAnalyticsComputePolicy.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
