// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The ZipDeflate compression read settings. </summary>
    public partial class ZipDeflateReadSettings : CompressionReadSettings
    {
        /// <summary> Initializes a new instance of <see cref="ZipDeflateReadSettings"/>. </summary>
        public ZipDeflateReadSettings()
        {
            CompressionReadSettingsType = "ZipDeflateReadSettings";
        }

        /// <summary> Initializes a new instance of <see cref="ZipDeflateReadSettings"/>. </summary>
        /// <param name="compressionReadSettingsType"> The Compression setting type. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="preserveZipFileNameAsFolder"> Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean). </param>
        internal ZipDeflateReadSettings(string compressionReadSettingsType, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<bool> preserveZipFileNameAsFolder) : base(compressionReadSettingsType, additionalProperties)
        {
            PreserveZipFileNameAsFolder = preserveZipFileNameAsFolder;
            CompressionReadSettingsType = compressionReadSettingsType ?? "ZipDeflateReadSettings";
        }

        /// <summary> Preserve the zip file name as folder path. Type: boolean (or Expression with resultType boolean). </summary>
        public DataFactoryElement<bool> PreserveZipFileNameAsFolder { get; set; }
    }
}
