// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Web activity authentication properties. </summary>
    public partial class WebActivityAuthentication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WebActivityAuthentication"/>. </summary>
        public WebActivityAuthentication()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WebActivityAuthentication"/>. </summary>
        /// <param name="webActivityAuthenticationType"> Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal). </param>
        /// <param name="pfx"> Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal. </param>
        /// <param name="username"> Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string). </param>
        /// <param name="password"> Password for the PFX file or basic authentication / Secret when used for ServicePrincipal. </param>
        /// <param name="resource"> Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string). </param>
        /// <param name="userTenant"> TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string). </param>
        /// <param name="credential"> The credential reference containing authentication information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WebActivityAuthentication(string webActivityAuthenticationType, DataFactorySecret pfx, DataFactoryElement<string> username, DataFactorySecret password, DataFactoryElement<string> resource, DataFactoryElement<string> userTenant, DataFactoryCredentialReference credential, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WebActivityAuthenticationType = webActivityAuthenticationType;
            Pfx = pfx;
            Username = username;
            Password = password;
            Resource = resource;
            UserTenant = userTenant;
            Credential = credential;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Web activity authentication (Basic/ClientCertificate/MSI/ServicePrincipal). </summary>
        public string WebActivityAuthenticationType { get; set; }
        /// <summary> Base64-encoded contents of a PFX file or Certificate when used for ServicePrincipal. </summary>
        public DataFactorySecret Pfx { get; set; }
        /// <summary> Web activity authentication user name for basic authentication or ClientID when used for ServicePrincipal. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> Username { get; set; }
        /// <summary> Password for the PFX file or basic authentication / Secret when used for ServicePrincipal. </summary>
        public DataFactorySecret Password { get; set; }
        /// <summary> Resource for which Azure Auth token will be requested when using MSI Authentication. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> Resource { get; set; }
        /// <summary> TenantId for which Azure Auth token will be requested when using ServicePrincipal Authentication. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> UserTenant { get; set; }
        /// <summary> The credential reference containing authentication information. </summary>
        public DataFactoryCredentialReference Credential { get; set; }
    }
}
