// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Microsoft Fabric Warehouse linked service. </summary>
    public partial class WarehouseLinkedService : DataFactoryLinkedServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="WarehouseLinkedService"/>. </summary>
        /// <param name="artifactId"> The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string). </param>
        /// <param name="endpoint"> The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactId"/> or <paramref name="endpoint"/> is null. </exception>
        public WarehouseLinkedService(DataFactoryElement<string> artifactId, DataFactoryElement<string> endpoint)
        {
            Argument.AssertNotNull(artifactId, nameof(artifactId));
            Argument.AssertNotNull(endpoint, nameof(endpoint));

            ArtifactId = artifactId;
            Endpoint = endpoint;
            LinkedServiceType = "Warehouse";
        }

        /// <summary> Initializes a new instance of <see cref="WarehouseLinkedService"/>. </summary>
        /// <param name="linkedServiceType"> Type of linked service. </param>
        /// <param name="linkedServiceVersion"> Version of the linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="artifactId"> The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string). </param>
        /// <param name="endpoint"> The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string). </param>
        /// <param name="workspaceId"> The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string). </param>
        /// <param name="servicePrincipalId"> The ID of the application used to authenticate against Microsoft Fabric Warehouse. Type: string (or Expression with resultType string). </param>
        /// <param name="servicePrincipalKey"> The Key of the application used to authenticate against Microsoft Fabric Warehouse. </param>
        /// <param name="tenant"> The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string). </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </param>
        /// <param name="servicePrincipalCredentialType"> The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string). </param>
        /// <param name="servicePrincipalCredential"> The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference. </param>
        internal WarehouseLinkedService(string linkedServiceType, string linkedServiceVersion, IntegrationRuntimeReference connectVia, string description, IDictionary<string, EntityParameterSpecification> parameters, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> artifactId, DataFactoryElement<string> endpoint, DataFactoryElement<string> workspaceId, DataFactoryElement<string> servicePrincipalId, DataFactorySecret servicePrincipalKey, DataFactoryElement<string> tenant, string encryptedCredential, DataFactoryElement<string> servicePrincipalCredentialType, DataFactorySecret servicePrincipalCredential) : base(linkedServiceType, linkedServiceVersion, connectVia, description, parameters, annotations, additionalProperties)
        {
            ArtifactId = artifactId;
            Endpoint = endpoint;
            WorkspaceId = workspaceId;
            ServicePrincipalId = servicePrincipalId;
            ServicePrincipalKey = servicePrincipalKey;
            Tenant = tenant;
            EncryptedCredential = encryptedCredential;
            ServicePrincipalCredentialType = servicePrincipalCredentialType;
            ServicePrincipalCredential = servicePrincipalCredential;
            LinkedServiceType = linkedServiceType ?? "Warehouse";
        }

        /// <summary> Initializes a new instance of <see cref="WarehouseLinkedService"/> for deserialization. </summary>
        internal WarehouseLinkedService()
        {
        }

        /// <summary> The ID of Microsoft Fabric Warehouse artifact. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> ArtifactId { get; set; }
        /// <summary> The endpoint of Microsoft Fabric Warehouse server. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> Endpoint { get; set; }
        /// <summary> The ID of Microsoft Fabric workspace. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> WorkspaceId { get; set; }
        /// <summary> The ID of the application used to authenticate against Microsoft Fabric Warehouse. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> ServicePrincipalId { get; set; }
        /// <summary> The Key of the application used to authenticate against Microsoft Fabric Warehouse. </summary>
        public DataFactorySecret ServicePrincipalKey { get; set; }
        /// <summary> The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> Tenant { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </summary>
        public string EncryptedCredential { get; set; }
        /// <summary> The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> ServicePrincipalCredentialType { get; set; }
        /// <summary> The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference. </summary>
        public DataFactorySecret ServicePrincipalCredential { get; set; }
    }
}
