// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Unknown version of LinkedIntegrationRuntimeType. </summary>
    internal partial class UnknownLinkedIntegrationRuntimeType : LinkedIntegrationRuntimeType
    {
        /// <summary> Initializes a new instance of <see cref="UnknownLinkedIntegrationRuntimeType"/>. </summary>
        /// <param name="authorizationType"> The authorization type for integration runtime sharing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownLinkedIntegrationRuntimeType(string authorizationType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(authorizationType, serializedAdditionalRawData)
        {
            AuthorizationType = authorizationType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownLinkedIntegrationRuntimeType"/> for deserialization. </summary>
        internal UnknownLinkedIntegrationRuntimeType()
        {
        }
    }
}
