// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Query parameters for triggers. </summary>
    public partial class TriggerFilterContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TriggerFilterContent"/>. </summary>
        public TriggerFilterContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TriggerFilterContent"/>. </summary>
        /// <param name="continuationToken"> The continuation token for getting the next page of results. Null for first page. </param>
        /// <param name="parentTriggerName"> The name of the parent TumblingWindowTrigger to get the child rerun triggers. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TriggerFilterContent(string continuationToken, string parentTriggerName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContinuationToken = continuationToken;
            ParentTriggerName = parentTriggerName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The continuation token for getting the next page of results. Null for first page. </summary>
        public string ContinuationToken { get; set; }
        /// <summary> The name of the parent TumblingWindowTrigger to get the child rerun triggers. </summary>
        public string ParentTriggerName { get; set; }
    }
}
