// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The TarGZip compression read settings. </summary>
    public partial class TarGzipReadSettings : CompressionReadSettings
    {
        /// <summary> Initializes a new instance of <see cref="TarGzipReadSettings"/>. </summary>
        public TarGzipReadSettings()
        {
            CompressionReadSettingsType = "TarGZipReadSettings";
        }

        /// <summary> Initializes a new instance of <see cref="TarGzipReadSettings"/>. </summary>
        /// <param name="compressionReadSettingsType"> The Compression setting type. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="preserveCompressionFileNameAsFolder"> Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean). </param>
        internal TarGzipReadSettings(string compressionReadSettingsType, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<bool> preserveCompressionFileNameAsFolder) : base(compressionReadSettingsType, additionalProperties)
        {
            PreserveCompressionFileNameAsFolder = preserveCompressionFileNameAsFolder;
            CompressionReadSettingsType = compressionReadSettingsType ?? "TarGZipReadSettings";
        }

        /// <summary> Preserve the compression file name as folder path. Type: boolean (or Expression with resultType boolean). </summary>
        public DataFactoryElement<bool> PreserveCompressionFileNameAsFolder { get; set; }
    }
}
