// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The status of the operation. </summary>
    public partial class SsisObjectMetadataStatusResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SsisObjectMetadataStatusResult"/>. </summary>
        internal SsisObjectMetadataStatusResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SsisObjectMetadataStatusResult"/>. </summary>
        /// <param name="status"> The status of the operation. </param>
        /// <param name="name"> The operation name. </param>
        /// <param name="properties"> The operation properties. </param>
        /// <param name="error"> The operation error message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SsisObjectMetadataStatusResult(string status, string name, string properties, string error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Name = name;
            Properties = properties;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the operation. </summary>
        public string Status { get; }
        /// <summary> The operation name. </summary>
        public string Name { get; }
        /// <summary> The operation properties. </summary>
        public string Properties { get; }
        /// <summary> The operation error message. </summary>
        public string Error { get; }
    }
}
