// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Ssis environment. </summary>
    public partial class SsisEnvironment : SsisObjectMetadata
    {
        /// <summary> Initializes a new instance of <see cref="SsisEnvironment"/>. </summary>
        internal SsisEnvironment()
        {
            Variables = new ChangeTrackingList<SsisVariable>();
            MetadataType = SsisObjectMetadataType.Environment;
        }

        /// <summary> Initializes a new instance of <see cref="SsisEnvironment"/>. </summary>
        /// <param name="metadataType"> Type of metadata. </param>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="folderId"> Folder id which contains environment. </param>
        /// <param name="variables"> Variable in environment. </param>
        internal SsisEnvironment(SsisObjectMetadataType metadataType, long? id, string name, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, long? folderId, IReadOnlyList<SsisVariable> variables) : base(metadataType, id, name, description, serializedAdditionalRawData)
        {
            FolderId = folderId;
            Variables = variables;
            MetadataType = metadataType;
        }

        /// <summary> Folder id which contains environment. </summary>
        public long? FolderId { get; }
        /// <summary> Variable in environment. </summary>
        public IReadOnlyList<SsisVariable> Variables { get; }
    }
}
