// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Spark Server linked service. </summary>
    public partial class SparkLinkedService : DataFactoryLinkedServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="SparkLinkedService"/>. </summary>
        /// <param name="host"> IP address or host name of the Spark server. </param>
        /// <param name="port"> The TCP port that the Spark server uses to listen for client connections. </param>
        /// <param name="authenticationType"> The authentication method used to access the Spark server. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="host"/> or <paramref name="port"/> is null. </exception>
        public SparkLinkedService(DataFactoryElement<string> host, DataFactoryElement<int> port, SparkAuthenticationType authenticationType)
        {
            Argument.AssertNotNull(host, nameof(host));
            Argument.AssertNotNull(port, nameof(port));

            Host = host;
            Port = port;
            AuthenticationType = authenticationType;
            LinkedServiceType = "Spark";
        }

        /// <summary> Initializes a new instance of <see cref="SparkLinkedService"/>. </summary>
        /// <param name="linkedServiceType"> Type of linked service. </param>
        /// <param name="linkedServiceVersion"> Version of the linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="host"> IP address or host name of the Spark server. </param>
        /// <param name="port"> The TCP port that the Spark server uses to listen for client connections. </param>
        /// <param name="serverType"> The type of Spark server. </param>
        /// <param name="thriftTransportProtocol"> The transport protocol to use in the Thrift layer. </param>
        /// <param name="authenticationType"> The authentication method used to access the Spark server. </param>
        /// <param name="username"> The user name that you use to access Spark Server. </param>
        /// <param name="password"> The password corresponding to the user name that you provided in the Username field. </param>
        /// <param name="httpPath"> The partial URL corresponding to the Spark server. </param>
        /// <param name="enableSsl"> Specifies whether the connections to the server are encrypted using SSL. The default value is false. </param>
        /// <param name="trustedCertPath"> The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. </param>
        /// <param name="useSystemTrustStore"> Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. </param>
        /// <param name="allowHostNameCNMismatch"> Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false. </param>
        /// <param name="allowSelfSignedServerCert"> Specifies whether to allow self-signed certificates from the server. The default value is false. </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </param>
        internal SparkLinkedService(string linkedServiceType, string linkedServiceVersion, IntegrationRuntimeReference connectVia, string description, IDictionary<string, EntityParameterSpecification> parameters, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> host, DataFactoryElement<int> port, SparkServerType? serverType, SparkThriftTransportProtocol? thriftTransportProtocol, SparkAuthenticationType authenticationType, DataFactoryElement<string> username, DataFactorySecret password, DataFactoryElement<string> httpPath, DataFactoryElement<bool> enableSsl, DataFactoryElement<string> trustedCertPath, DataFactoryElement<bool> useSystemTrustStore, DataFactoryElement<bool> allowHostNameCNMismatch, DataFactoryElement<bool> allowSelfSignedServerCert, string encryptedCredential) : base(linkedServiceType, linkedServiceVersion, connectVia, description, parameters, annotations, additionalProperties)
        {
            Host = host;
            Port = port;
            ServerType = serverType;
            ThriftTransportProtocol = thriftTransportProtocol;
            AuthenticationType = authenticationType;
            Username = username;
            Password = password;
            HttpPath = httpPath;
            EnableSsl = enableSsl;
            TrustedCertPath = trustedCertPath;
            UseSystemTrustStore = useSystemTrustStore;
            AllowHostNameCNMismatch = allowHostNameCNMismatch;
            AllowSelfSignedServerCert = allowSelfSignedServerCert;
            EncryptedCredential = encryptedCredential;
            LinkedServiceType = linkedServiceType ?? "Spark";
        }

        /// <summary> Initializes a new instance of <see cref="SparkLinkedService"/> for deserialization. </summary>
        internal SparkLinkedService()
        {
        }

        /// <summary> IP address or host name of the Spark server. </summary>
        public DataFactoryElement<string> Host { get; set; }
        /// <summary> The TCP port that the Spark server uses to listen for client connections. </summary>
        public DataFactoryElement<int> Port { get; set; }
        /// <summary> The type of Spark server. </summary>
        public SparkServerType? ServerType { get; set; }
        /// <summary> The transport protocol to use in the Thrift layer. </summary>
        public SparkThriftTransportProtocol? ThriftTransportProtocol { get; set; }
        /// <summary> The authentication method used to access the Spark server. </summary>
        public SparkAuthenticationType AuthenticationType { get; set; }
        /// <summary> The user name that you use to access Spark Server. </summary>
        public DataFactoryElement<string> Username { get; set; }
        /// <summary> The password corresponding to the user name that you provided in the Username field. </summary>
        public DataFactorySecret Password { get; set; }
        /// <summary> The partial URL corresponding to the Spark server. </summary>
        public DataFactoryElement<string> HttpPath { get; set; }
        /// <summary> Specifies whether the connections to the server are encrypted using SSL. The default value is false. </summary>
        public DataFactoryElement<bool> EnableSsl { get; set; }
        /// <summary> The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. </summary>
        public DataFactoryElement<string> TrustedCertPath { get; set; }
        /// <summary> Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false. </summary>
        public DataFactoryElement<bool> UseSystemTrustStore { get; set; }
        /// <summary> Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false. </summary>
        public DataFactoryElement<bool> AllowHostNameCNMismatch { get; set; }
        /// <summary> Specifies whether to allow self-signed certificates from the server. The default value is false. </summary>
        public DataFactoryElement<bool> AllowSelfSignedServerCert { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </summary>
        public string EncryptedCredential { get; set; }
    }
}
