// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The type used for authentication. Type: string. </summary>
    public readonly partial struct SnowflakeAuthenticationType : IEquatable<SnowflakeAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SnowflakeAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SnowflakeAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string KeyPairValue = "KeyPair";
        private const string AADServicePrincipalValue = "AADServicePrincipal";

        /// <summary> Basic. </summary>
        public static SnowflakeAuthenticationType Basic { get; } = new SnowflakeAuthenticationType(BasicValue);
        /// <summary> KeyPair. </summary>
        public static SnowflakeAuthenticationType KeyPair { get; } = new SnowflakeAuthenticationType(KeyPairValue);
        /// <summary> AADServicePrincipal. </summary>
        public static SnowflakeAuthenticationType AADServicePrincipal { get; } = new SnowflakeAuthenticationType(AADServicePrincipalValue);
        /// <summary> Determines if two <see cref="SnowflakeAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(SnowflakeAuthenticationType left, SnowflakeAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SnowflakeAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(SnowflakeAuthenticationType left, SnowflakeAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SnowflakeAuthenticationType"/>. </summary>
        public static implicit operator SnowflakeAuthenticationType(string value) => new SnowflakeAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SnowflakeAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SnowflakeAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
