// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Service principal credential. </summary>
    public partial class ServicePrincipalCredential : DataFactoryCredential
    {
        /// <summary> Initializes a new instance of <see cref="ServicePrincipalCredential"/>. </summary>
        public ServicePrincipalCredential()
        {
            CredentialType = "ServicePrincipal";
        }

        /// <summary> Initializes a new instance of <see cref="ServicePrincipalCredential"/>. </summary>
        /// <param name="credentialType"> Type of credential. </param>
        /// <param name="description"> Credential description. </param>
        /// <param name="annotations"> List of tags that can be used for describing the Credential. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="servicePrincipalId"> The app ID of the service principal used to authenticate. </param>
        /// <param name="servicePrincipalKey"> The key of the service principal used to authenticate. </param>
        /// <param name="tenant"> The ID of the tenant to which the service principal belongs. </param>
        internal ServicePrincipalCredential(string credentialType, string description, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> servicePrincipalId, DataFactoryKeyVaultSecret servicePrincipalKey, DataFactoryElement<string> tenant) : base(credentialType, description, annotations, additionalProperties)
        {
            ServicePrincipalId = servicePrincipalId;
            ServicePrincipalKey = servicePrincipalKey;
            Tenant = tenant;
            CredentialType = credentialType ?? "ServicePrincipal";
        }

        /// <summary> The app ID of the service principal used to authenticate. </summary>
        public DataFactoryElement<string> ServicePrincipalId { get; set; }
        /// <summary> The key of the service principal used to authenticate. </summary>
        public DataFactoryKeyVaultSecret ServicePrincipalKey { get; set; }
        /// <summary> The ID of the tenant to which the service principal belongs. </summary>
        public DataFactoryElement<string> Tenant { get; set; }
    }
}
