// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Self referenced tumbling window trigger dependency. </summary>
    public partial class SelfDependencyTumblingWindowTriggerReference : DependencyReference
    {
        /// <summary> Initializes a new instance of <see cref="SelfDependencyTumblingWindowTriggerReference"/>. </summary>
        /// <param name="offset"> Timespan applied to the start time of a tumbling window when evaluating dependency. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="offset"/> is null. </exception>
        public SelfDependencyTumblingWindowTriggerReference(string offset)
        {
            Argument.AssertNotNull(offset, nameof(offset));

            Offset = offset;
            DependencyReferenceType = "SelfDependencyTumblingWindowTriggerReference";
        }

        /// <summary> Initializes a new instance of <see cref="SelfDependencyTumblingWindowTriggerReference"/>. </summary>
        /// <param name="dependencyReferenceType"> The type of dependency reference. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="offset"> Timespan applied to the start time of a tumbling window when evaluating dependency. </param>
        /// <param name="size"> The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used. </param>
        internal SelfDependencyTumblingWindowTriggerReference(string dependencyReferenceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string offset, string size) : base(dependencyReferenceType, serializedAdditionalRawData)
        {
            Offset = offset;
            Size = size;
            DependencyReferenceType = dependencyReferenceType ?? "SelfDependencyTumblingWindowTriggerReference";
        }

        /// <summary> Initializes a new instance of <see cref="SelfDependencyTumblingWindowTriggerReference"/> for deserialization. </summary>
        internal SelfDependencyTumblingWindowTriggerReference()
        {
        }

        /// <summary> Timespan applied to the start time of a tumbling window when evaluating dependency. </summary>
        public string Offset { get; set; }
        /// <summary> The size of the window when evaluating the dependency. If undefined the frequency of the tumbling window will be used. </summary>
        public string Size { get; set; }
    }
}
