// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The direction of the parameter. </summary>
    public readonly partial struct ScriptActivityParameterDirection : IEquatable<ScriptActivityParameterDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScriptActivityParameterDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScriptActivityParameterDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InputValue = "Input";
        private const string OutputValue = "Output";
        private const string InputOutputValue = "InputOutput";

        /// <summary> Input. </summary>
        public static ScriptActivityParameterDirection Input { get; } = new ScriptActivityParameterDirection(InputValue);
        /// <summary> Output. </summary>
        public static ScriptActivityParameterDirection Output { get; } = new ScriptActivityParameterDirection(OutputValue);
        /// <summary> InputOutput. </summary>
        public static ScriptActivityParameterDirection InputOutput { get; } = new ScriptActivityParameterDirection(InputOutputValue);
        /// <summary> Determines if two <see cref="ScriptActivityParameterDirection"/> values are the same. </summary>
        public static bool operator ==(ScriptActivityParameterDirection left, ScriptActivityParameterDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScriptActivityParameterDirection"/> values are not the same. </summary>
        public static bool operator !=(ScriptActivityParameterDirection left, ScriptActivityParameterDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScriptActivityParameterDirection"/>. </summary>
        public static implicit operator ScriptActivityParameterDirection(string value) => new ScriptActivityParameterDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScriptActivityParameterDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScriptActivityParameterDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
