// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The authentication type to be used to connect to the SAP HANA server. </summary>
    public readonly partial struct SapHanaAuthenticationType : IEquatable<SapHanaAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SapHanaAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SapHanaAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string WindowsValue = "Windows";

        /// <summary> Basic. </summary>
        public static SapHanaAuthenticationType Basic { get; } = new SapHanaAuthenticationType(BasicValue);
        /// <summary> Windows. </summary>
        public static SapHanaAuthenticationType Windows { get; } = new SapHanaAuthenticationType(WindowsValue);
        /// <summary> Determines if two <see cref="SapHanaAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(SapHanaAuthenticationType left, SapHanaAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SapHanaAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(SapHanaAuthenticationType left, SapHanaAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SapHanaAuthenticationType"/>. </summary>
        public static implicit operator SapHanaAuthenticationType(string value) => new SapHanaAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SapHanaAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SapHanaAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
