// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The write behavior for the operation. Default is Insert. </summary>
    public readonly partial struct SalesforceV2SinkWriteBehavior : IEquatable<SalesforceV2SinkWriteBehavior>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SalesforceV2SinkWriteBehavior"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SalesforceV2SinkWriteBehavior(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InsertValue = "Insert";
        private const string UpsertValue = "Upsert";

        /// <summary> Insert. </summary>
        public static SalesforceV2SinkWriteBehavior Insert { get; } = new SalesforceV2SinkWriteBehavior(InsertValue);
        /// <summary> Upsert. </summary>
        public static SalesforceV2SinkWriteBehavior Upsert { get; } = new SalesforceV2SinkWriteBehavior(UpsertValue);
        /// <summary> Determines if two <see cref="SalesforceV2SinkWriteBehavior"/> values are the same. </summary>
        public static bool operator ==(SalesforceV2SinkWriteBehavior left, SalesforceV2SinkWriteBehavior right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SalesforceV2SinkWriteBehavior"/> values are not the same. </summary>
        public static bool operator !=(SalesforceV2SinkWriteBehavior left, SalesforceV2SinkWriteBehavior right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SalesforceV2SinkWriteBehavior"/>. </summary>
        public static implicit operator SalesforceV2SinkWriteBehavior(string value) => new SalesforceV2SinkWriteBehavior(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SalesforceV2SinkWriteBehavior other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SalesforceV2SinkWriteBehavior other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
