// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> A copy activity Salesforce V2 sink. </summary>
    public partial class SalesforceV2Sink : CopySink
    {
        /// <summary> Initializes a new instance of <see cref="SalesforceV2Sink"/>. </summary>
        public SalesforceV2Sink()
        {
            CopySinkType = "SalesforceV2Sink";
        }

        /// <summary> Initializes a new instance of <see cref="SalesforceV2Sink"/>. </summary>
        /// <param name="copySinkType"> Copy sink type. </param>
        /// <param name="writeBatchSize"> Write batch size. Type: integer (or Expression with resultType integer), minimum: 0. </param>
        /// <param name="writeBatchTimeout"> Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="sinkRetryCount"> Sink retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sinkRetryWait"> Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="disableMetricsCollection"> If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="writeBehavior"> The write behavior for the operation. Default is Insert. </param>
        /// <param name="externalIdFieldName"> The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string). </param>
        /// <param name="ignoreNullValues"> The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean). </param>
        internal SalesforceV2Sink(string copySinkType, DataFactoryElement<int> writeBatchSize, DataFactoryElement<string> writeBatchTimeout, DataFactoryElement<int> sinkRetryCount, DataFactoryElement<string> sinkRetryWait, DataFactoryElement<int> maxConcurrentConnections, DataFactoryElement<bool> disableMetricsCollection, IDictionary<string, BinaryData> additionalProperties, SalesforceV2SinkWriteBehavior? writeBehavior, DataFactoryElement<string> externalIdFieldName, DataFactoryElement<bool> ignoreNullValues) : base(copySinkType, writeBatchSize, writeBatchTimeout, sinkRetryCount, sinkRetryWait, maxConcurrentConnections, disableMetricsCollection, additionalProperties)
        {
            WriteBehavior = writeBehavior;
            ExternalIdFieldName = externalIdFieldName;
            IgnoreNullValues = ignoreNullValues;
            CopySinkType = copySinkType ?? "SalesforceV2Sink";
        }

        /// <summary> The write behavior for the operation. Default is Insert. </summary>
        public SalesforceV2SinkWriteBehavior? WriteBehavior { get; set; }
        /// <summary> The name of the external ID field for upsert operation. Default value is 'Id' column. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> ExternalIdFieldName { get; set; }
        /// <summary> The flag indicating whether or not to ignore null values from input dataset (except key fields) during write operation. Default value is false. If set it to true, it means ADF will leave the data in the destination object unchanged when doing upsert/update operation and insert defined default value when doing insert operation, versus ADF will update the data in the destination object to NULL when doing upsert/update operation and insert NULL value when doing insert operation. Type: boolean (or Expression with resultType boolean). </summary>
        public DataFactoryElement<bool> IgnoreNullValues { get; set; }
    }
}
