// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Linked service for Quickbase. </summary>
    public partial class QuickbaseLinkedService : DataFactoryLinkedServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="QuickbaseLinkedService"/>. </summary>
        /// <param name="uri"> The url to connect Quickbase source. Type: string (or Expression with resultType string). </param>
        /// <param name="userToken"> The user token for the Quickbase source. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> or <paramref name="userToken"/> is null. </exception>
        public QuickbaseLinkedService(DataFactoryElement<string> uri, DataFactorySecret userToken)
        {
            Argument.AssertNotNull(uri, nameof(uri));
            Argument.AssertNotNull(userToken, nameof(userToken));

            Uri = uri;
            UserToken = userToken;
            LinkedServiceType = "Quickbase";
        }

        /// <summary> Initializes a new instance of <see cref="QuickbaseLinkedService"/>. </summary>
        /// <param name="linkedServiceType"> Type of linked service. </param>
        /// <param name="linkedServiceVersion"> Version of the linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="uri"> The url to connect Quickbase source. Type: string (or Expression with resultType string). </param>
        /// <param name="userToken"> The user token for the Quickbase source. </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </param>
        internal QuickbaseLinkedService(string linkedServiceType, string linkedServiceVersion, IntegrationRuntimeReference connectVia, string description, IDictionary<string, EntityParameterSpecification> parameters, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> uri, DataFactorySecret userToken, string encryptedCredential) : base(linkedServiceType, linkedServiceVersion, connectVia, description, parameters, annotations, additionalProperties)
        {
            Uri = uri;
            UserToken = userToken;
            EncryptedCredential = encryptedCredential;
            LinkedServiceType = linkedServiceType ?? "Quickbase";
        }

        /// <summary> Initializes a new instance of <see cref="QuickbaseLinkedService"/> for deserialization. </summary>
        internal QuickbaseLinkedService()
        {
        }

        /// <summary> The url to connect Quickbase source. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> Uri { get; set; }
        /// <summary> The user token for the Quickbase source. </summary>
        public DataFactorySecret UserToken { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </summary>
        public string EncryptedCredential { get; set; }
    }
}
