// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Map Power Query mashup query to sink dataset(s). </summary>
    public partial class PowerQuerySinkMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PowerQuerySinkMapping"/>. </summary>
        public PowerQuerySinkMapping()
        {
            DataflowSinks = new ChangeTrackingList<PowerQuerySink>();
        }

        /// <summary> Initializes a new instance of <see cref="PowerQuerySinkMapping"/>. </summary>
        /// <param name="queryName"> Name of the query in Power Query mashup document. </param>
        /// <param name="dataflowSinks"> List of sinks mapped to Power Query mashup query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PowerQuerySinkMapping(string queryName, IList<PowerQuerySink> dataflowSinks, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            QueryName = queryName;
            DataflowSinks = dataflowSinks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the query in Power Query mashup document. </summary>
        public string QueryName { get; set; }
        /// <summary> List of sinks mapped to Power Query mashup query. </summary>
        public IList<PowerQuerySink> DataflowSinks { get; }
    }
}
