// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Activity state. This is an optional property and if not provided, the state will be Active by default. </summary>
    public readonly partial struct PipelineActivityState : IEquatable<PipelineActivityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PipelineActivityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PipelineActivityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string InactiveValue = "Inactive";

        /// <summary> Active. </summary>
        public static PipelineActivityState Active { get; } = new PipelineActivityState(ActiveValue);
        /// <summary> Inactive. </summary>
        public static PipelineActivityState Inactive { get; } = new PipelineActivityState(InactiveValue);
        /// <summary> Determines if two <see cref="PipelineActivityState"/> values are the same. </summary>
        public static bool operator ==(PipelineActivityState left, PipelineActivityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PipelineActivityState"/> values are not the same. </summary>
        public static bool operator !=(PipelineActivityState left, PipelineActivityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PipelineActivityState"/>. </summary>
        public static implicit operator PipelineActivityState(string value) => new PipelineActivityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PipelineActivityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PipelineActivityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
