// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    public partial class PipelineActivityPolicy : IUtf8JsonSerializable, IJsonModel<PipelineActivityPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PipelineActivityPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PipelineActivityPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineActivityPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PipelineActivityPolicy)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Timeout))
            {
                writer.WritePropertyName("timeout"u8);
                JsonSerializer.Serialize(writer, Timeout);
            }
            if (Optional.IsDefined(Retry))
            {
                writer.WritePropertyName("retry"u8);
                JsonSerializer.Serialize(writer, Retry);
            }
            if (Optional.IsDefined(RetryIntervalInSeconds))
            {
                writer.WritePropertyName("retryIntervalInSeconds"u8);
                writer.WriteNumberValue(RetryIntervalInSeconds.Value);
            }
            if (Optional.IsDefined(IsSecureInputEnabled))
            {
                writer.WritePropertyName("secureInput"u8);
                writer.WriteBooleanValue(IsSecureInputEnabled.Value);
            }
            if (Optional.IsDefined(IsSecureOutputEnabled))
            {
                writer.WritePropertyName("secureOutput"u8);
                writer.WriteBooleanValue(IsSecureOutputEnabled.Value);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                using (JsonDocument document = JsonDocument.Parse(item.Value))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
        }

        PipelineActivityPolicy IJsonModel<PipelineActivityPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineActivityPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PipelineActivityPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePipelineActivityPolicy(document.RootElement, options);
        }

        internal static PipelineActivityPolicy DeserializePipelineActivityPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DataFactoryElement<string> timeout = default;
            DataFactoryElement<int> retry = default;
            int? retryIntervalInSeconds = default;
            bool? secureInput = default;
            bool? secureOutput = default;
            IDictionary<string, BinaryData> additionalProperties = default;
            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("timeout"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeout = JsonSerializer.Deserialize<DataFactoryElement<string>>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("retry"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retry = JsonSerializer.Deserialize<DataFactoryElement<int>>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("retryIntervalInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retryIntervalInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("secureInput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secureInput = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("secureOutput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secureOutput = property.Value.GetBoolean();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
            }
            additionalProperties = additionalPropertiesDictionary;
            return new PipelineActivityPolicy(
                timeout,
                retry,
                retryIntervalInSeconds,
                secureInput,
                secureOutput,
                additionalProperties);
        }

        BinaryData IPersistableModel<PipelineActivityPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineActivityPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PipelineActivityPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        PipelineActivityPolicy IPersistableModel<PipelineActivityPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PipelineActivityPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePipelineActivityPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PipelineActivityPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PipelineActivityPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
