// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The authentication mechanism used to connect to the Phoenix server. </summary>
    public readonly partial struct PhoenixAuthenticationType : IEquatable<PhoenixAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PhoenixAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PhoenixAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnonymousValue = "Anonymous";
        private const string UsernameAndPasswordValue = "UsernameAndPassword";
        private const string WindowsAzureHDInsightServiceValue = "WindowsAzureHDInsightService";

        /// <summary> Anonymous. </summary>
        public static PhoenixAuthenticationType Anonymous { get; } = new PhoenixAuthenticationType(AnonymousValue);
        /// <summary> UsernameAndPassword. </summary>
        public static PhoenixAuthenticationType UsernameAndPassword { get; } = new PhoenixAuthenticationType(UsernameAndPasswordValue);
        /// <summary> WindowsAzureHDInsightService. </summary>
        public static PhoenixAuthenticationType WindowsAzureHDInsightService { get; } = new PhoenixAuthenticationType(WindowsAzureHDInsightServiceValue);
        /// <summary> Determines if two <see cref="PhoenixAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(PhoenixAuthenticationType left, PhoenixAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PhoenixAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(PhoenixAuthenticationType left, PhoenixAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PhoenixAuthenticationType"/>. </summary>
        public static implicit operator PhoenixAuthenticationType(string value) => new PhoenixAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PhoenixAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PhoenixAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
