// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Type of authentication used to connect to the OData service. </summary>
    public readonly partial struct ODataAuthenticationType : IEquatable<ODataAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ODataAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ODataAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string AnonymousValue = "Anonymous";
        private const string WindowsValue = "Windows";
        private const string AadServicePrincipalValue = "AadServicePrincipal";
        private const string ManagedServiceIdentityValue = "ManagedServiceIdentity";

        /// <summary> Basic. </summary>
        public static ODataAuthenticationType Basic { get; } = new ODataAuthenticationType(BasicValue);
        /// <summary> Anonymous. </summary>
        public static ODataAuthenticationType Anonymous { get; } = new ODataAuthenticationType(AnonymousValue);
        /// <summary> Windows. </summary>
        public static ODataAuthenticationType Windows { get; } = new ODataAuthenticationType(WindowsValue);
        /// <summary> AadServicePrincipal. </summary>
        public static ODataAuthenticationType AadServicePrincipal { get; } = new ODataAuthenticationType(AadServicePrincipalValue);
        /// <summary> ManagedServiceIdentity. </summary>
        public static ODataAuthenticationType ManagedServiceIdentity { get; } = new ODataAuthenticationType(ManagedServiceIdentityValue);
        /// <summary> Determines if two <see cref="ODataAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(ODataAuthenticationType left, ODataAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ODataAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(ODataAuthenticationType left, ODataAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ODataAuthenticationType"/>. </summary>
        public static implicit operator ODataAuthenticationType(string value) => new ODataAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ODataAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ODataAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
