// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Notebook parameter type. </summary>
    public readonly partial struct NotebookParameterType : IEquatable<NotebookParameterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotebookParameterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotebookParameterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "string";
        private const string IntValue = "int";
        private const string FloatValue = "float";
        private const string BoolValue = "bool";

        /// <summary> string. </summary>
        public static NotebookParameterType String { get; } = new NotebookParameterType(StringValue);
        /// <summary> int. </summary>
        public static NotebookParameterType Int { get; } = new NotebookParameterType(IntValue);
        /// <summary> float. </summary>
        public static NotebookParameterType Float { get; } = new NotebookParameterType(FloatValue);
        /// <summary> bool. </summary>
        public static NotebookParameterType Bool { get; } = new NotebookParameterType(BoolValue);
        /// <summary> Determines if two <see cref="NotebookParameterType"/> values are the same. </summary>
        public static bool operator ==(NotebookParameterType left, NotebookParameterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotebookParameterType"/> values are not the same. </summary>
        public static bool operator !=(NotebookParameterType left, NotebookParameterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotebookParameterType"/>. </summary>
        public static implicit operator NotebookParameterType(string value) => new NotebookParameterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotebookParameterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotebookParameterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
