// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Notebook parameter. </summary>
    public partial class NotebookParameter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotebookParameter"/>. </summary>
        public NotebookParameter()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NotebookParameter"/>. </summary>
        /// <param name="value"> Notebook parameter value. Type: string (or Expression with resultType string). </param>
        /// <param name="parameterType"> Notebook parameter type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotebookParameter(DataFactoryElement<string> value, NotebookParameterType? parameterType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            ParameterType = parameterType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Notebook parameter value. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> Value { get; set; }
        /// <summary> Notebook parameter type. </summary>
        public NotebookParameterType? ParameterType { get; set; }
    }
}
