// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The authentication type to be used to connect to the MongoDB database. </summary>
    public readonly partial struct MongoDBAuthenticationType : IEquatable<MongoDBAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoDBAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoDBAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string AnonymousValue = "Anonymous";

        /// <summary> Basic. </summary>
        public static MongoDBAuthenticationType Basic { get; } = new MongoDBAuthenticationType(BasicValue);
        /// <summary> Anonymous. </summary>
        public static MongoDBAuthenticationType Anonymous { get; } = new MongoDBAuthenticationType(AnonymousValue);
        /// <summary> Determines if two <see cref="MongoDBAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(MongoDBAuthenticationType left, MongoDBAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoDBAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(MongoDBAuthenticationType left, MongoDBAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoDBAuthenticationType"/>. </summary>
        public static implicit operator MongoDBAuthenticationType(string value) => new MongoDBAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoDBAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoDBAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
