// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> A object which contains list of tables and connection details for a target connection. </summary>
    public partial class MapperTargetConnectionsInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MapperTargetConnectionsInfo"/>. </summary>
        public MapperTargetConnectionsInfo()
        {
            TargetEntities = new ChangeTrackingList<MapperTable>();
            DataMapperMappings = new ChangeTrackingList<DataMapperMapping>();
            Relationships = new ChangeTrackingList<BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="MapperTargetConnectionsInfo"/>. </summary>
        /// <param name="targetEntities"> List of source tables for a target connection. </param>
        /// <param name="connection"> Source connection details. </param>
        /// <param name="dataMapperMappings"> List of table mappings. </param>
        /// <param name="relationships"> List of relationship info among the tables. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MapperTargetConnectionsInfo(IList<MapperTable> targetEntities, MapperConnection connection, IList<DataMapperMapping> dataMapperMappings, IList<BinaryData> relationships, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetEntities = targetEntities;
            Connection = connection;
            DataMapperMappings = dataMapperMappings;
            Relationships = relationships;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of source tables for a target connection. </summary>
        public IList<MapperTable> TargetEntities { get; }
        /// <summary> Source connection details. </summary>
        public MapperConnection Connection { get; set; }
        /// <summary> List of table mappings. </summary>
        public IList<DataMapperMapping> DataMapperMappings { get; }
        /// <summary>
        /// List of relationship info among the tables.
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IList<BinaryData> Relationships { get; }
    }
}
