// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Schema of a CDC table in terms of column names and their corresponding data types. </summary>
    public partial class MapperTableSchema
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MapperTableSchema"/>. </summary>
        public MapperTableSchema()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MapperTableSchema"/>. </summary>
        /// <param name="name"> Name of the column. </param>
        /// <param name="dataType"> Data type of the column. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MapperTableSchema(string name, string dataType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DataType = dataType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the column. </summary>
        public string Name { get; set; }
        /// <summary> Data type of the column. </summary>
        public string DataType { get; set; }
    }
}
