// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> CDC policy recurrence details. </summary>
    public partial class MapperPolicyRecurrence
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MapperPolicyRecurrence"/>. </summary>
        public MapperPolicyRecurrence()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MapperPolicyRecurrence"/>. </summary>
        /// <param name="frequency"> Frequency of period in terms of 'Hour', 'Minute' or 'Second'. </param>
        /// <param name="interval"> Actual interval value as per chosen frequency. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MapperPolicyRecurrence(MapperPolicyRecurrenceFrequencyType? frequency, int? interval, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Frequency = frequency;
            Interval = interval;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Frequency of period in terms of 'Hour', 'Minute' or 'Second'. </summary>
        public MapperPolicyRecurrenceFrequencyType? Frequency { get; set; }
        /// <summary> Actual interval value as per chosen frequency. </summary>
        public int? Interval { get; set; }
    }
}
