// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Source or target connection reference details. </summary>
    public partial class MapperConnectionReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MapperConnectionReference"/>. </summary>
        public MapperConnectionReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MapperConnectionReference"/>. </summary>
        /// <param name="connectionName"> Name of the connection. </param>
        /// <param name="connectionType"> Type of connection via linked service or dataset. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MapperConnectionReference(string connectionName, MapperConnectionType? connectionType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConnectionName = connectionName;
            ConnectionType = connectionType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the connection. </summary>
        public string ConnectionName { get; set; }
        /// <summary> Type of connection via linked service or dataset. </summary>
        public MapperConnectionType? ConnectionType { get; set; }
    }
}
