// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataFactory.Models
{
    public partial class MapperAttributeMapping : IUtf8JsonSerializable, IJsonModel<MapperAttributeMapping>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MapperAttributeMapping>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MapperAttributeMapping>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapperAttributeMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MapperAttributeMapping)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(MappingType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(MappingType.Value.ToString());
            }
            if (Optional.IsDefined(FunctionName))
            {
                writer.WritePropertyName("functionName"u8);
                writer.WriteStringValue(FunctionName);
            }
            if (Optional.IsDefined(Expression))
            {
                writer.WritePropertyName("expression"u8);
                writer.WriteStringValue(Expression);
            }
            if (Optional.IsDefined(AttributeReference))
            {
                writer.WritePropertyName("attributeReference"u8);
                writer.WriteObjectValue(AttributeReference, options);
            }
            if (Optional.IsCollectionDefined(AttributeReferences))
            {
                writer.WritePropertyName("attributeReferences"u8);
                writer.WriteStartArray();
                foreach (var item in AttributeReferences)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MapperAttributeMapping IJsonModel<MapperAttributeMapping>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapperAttributeMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MapperAttributeMapping)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMapperAttributeMapping(document.RootElement, options);
        }

        internal static MapperAttributeMapping DeserializeMapperAttributeMapping(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            MappingType? type = default;
            string functionName = default;
            string expression = default;
            MapperAttributeReference attributeReference = default;
            IList<MapperAttributeReference> attributeReferences = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new MappingType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("functionName"u8))
                {
                    functionName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("expression"u8))
                {
                    expression = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("attributeReference"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    attributeReference = MapperAttributeReference.DeserializeMapperAttributeReference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("attributeReferences"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MapperAttributeReference> array = new List<MapperAttributeReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MapperAttributeReference.DeserializeMapperAttributeReference(item, options));
                    }
                    attributeReferences = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MapperAttributeMapping(
                name,
                type,
                functionName,
                expression,
                attributeReference,
                attributeReferences ?? new ChangeTrackingList<MapperAttributeReference>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MapperAttributeMapping>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapperAttributeMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MapperAttributeMapping)} does not support writing '{options.Format}' format.");
            }
        }

        MapperAttributeMapping IPersistableModel<MapperAttributeMapping>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapperAttributeMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMapperAttributeMapping(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MapperAttributeMapping)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MapperAttributeMapping>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
