// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Managed Virtual Network reference type. </summary>
    public readonly partial struct ManagedVirtualNetworkReferenceType : IEquatable<ManagedVirtualNetworkReferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedVirtualNetworkReferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedVirtualNetworkReferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManagedVirtualNetworkReferenceValue = "ManagedVirtualNetworkReference";

        /// <summary> ManagedVirtualNetworkReference. </summary>
        public static ManagedVirtualNetworkReferenceType ManagedVirtualNetworkReference { get; } = new ManagedVirtualNetworkReferenceType(ManagedVirtualNetworkReferenceValue);
        /// <summary> Determines if two <see cref="ManagedVirtualNetworkReferenceType"/> values are the same. </summary>
        public static bool operator ==(ManagedVirtualNetworkReferenceType left, ManagedVirtualNetworkReferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedVirtualNetworkReferenceType"/> values are not the same. </summary>
        public static bool operator !=(ManagedVirtualNetworkReferenceType left, ManagedVirtualNetworkReferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedVirtualNetworkReferenceType"/>. </summary>
        public static implicit operator ManagedVirtualNetworkReferenceType(string value) => new ManagedVirtualNetworkReferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedVirtualNetworkReferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedVirtualNetworkReferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
