// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The managed integration runtime node status. </summary>
    public readonly partial struct ManagedIntegrationRuntimeNodeStatus : IEquatable<ManagedIntegrationRuntimeNodeStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedIntegrationRuntimeNodeStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedIntegrationRuntimeNodeStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StartingValue = "Starting";
        private const string AvailableValue = "Available";
        private const string RecyclingValue = "Recycling";
        private const string UnavailableValue = "Unavailable";

        /// <summary> Starting. </summary>
        public static ManagedIntegrationRuntimeNodeStatus Starting { get; } = new ManagedIntegrationRuntimeNodeStatus(StartingValue);
        /// <summary> Available. </summary>
        public static ManagedIntegrationRuntimeNodeStatus Available { get; } = new ManagedIntegrationRuntimeNodeStatus(AvailableValue);
        /// <summary> Recycling. </summary>
        public static ManagedIntegrationRuntimeNodeStatus Recycling { get; } = new ManagedIntegrationRuntimeNodeStatus(RecyclingValue);
        /// <summary> Unavailable. </summary>
        public static ManagedIntegrationRuntimeNodeStatus Unavailable { get; } = new ManagedIntegrationRuntimeNodeStatus(UnavailableValue);
        /// <summary> Determines if two <see cref="ManagedIntegrationRuntimeNodeStatus"/> values are the same. </summary>
        public static bool operator ==(ManagedIntegrationRuntimeNodeStatus left, ManagedIntegrationRuntimeNodeStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedIntegrationRuntimeNodeStatus"/> values are not the same. </summary>
        public static bool operator !=(ManagedIntegrationRuntimeNodeStatus left, ManagedIntegrationRuntimeNodeStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedIntegrationRuntimeNodeStatus"/>. </summary>
        public static implicit operator ManagedIntegrationRuntimeNodeStatus(string value) => new ManagedIntegrationRuntimeNodeStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedIntegrationRuntimeNodeStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedIntegrationRuntimeNodeStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
