// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The role based access control (RBAC) authorization type integration runtime. </summary>
    public partial class LinkedIntegrationRuntimeRbacAuthorization : LinkedIntegrationRuntimeType
    {
        /// <summary> Initializes a new instance of <see cref="LinkedIntegrationRuntimeRbacAuthorization"/>. </summary>
        /// <param name="resourceId"> The resource identifier of the integration runtime to be shared. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public LinkedIntegrationRuntimeRbacAuthorization(ResourceIdentifier resourceId)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            ResourceId = resourceId;
            AuthorizationType = "RBAC";
        }

        /// <summary> Initializes a new instance of <see cref="LinkedIntegrationRuntimeRbacAuthorization"/>. </summary>
        /// <param name="authorizationType"> The authorization type for integration runtime sharing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="resourceId"> The resource identifier of the integration runtime to be shared. </param>
        /// <param name="credential"> The credential reference containing authentication information. </param>
        internal LinkedIntegrationRuntimeRbacAuthorization(string authorizationType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier resourceId, DataFactoryCredentialReference credential) : base(authorizationType, serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            Credential = credential;
            AuthorizationType = authorizationType ?? "RBAC";
        }

        /// <summary> Initializes a new instance of <see cref="LinkedIntegrationRuntimeRbacAuthorization"/> for deserialization. </summary>
        internal LinkedIntegrationRuntimeRbacAuthorization()
        {
        }

        /// <summary> The resource identifier of the integration runtime to be shared. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> The credential reference containing authentication information. </summary>
        public DataFactoryCredentialReference Credential { get; set; }
    }
}
