// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Data factory name for linked integration runtime request. </summary>
    public partial class LinkedIntegrationRuntimeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LinkedIntegrationRuntimeContent"/>. </summary>
        /// <param name="linkedFactoryName"> The data factory name for linked integration runtime. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkedFactoryName"/> is null. </exception>
        public LinkedIntegrationRuntimeContent(string linkedFactoryName)
        {
            Argument.AssertNotNull(linkedFactoryName, nameof(linkedFactoryName));

            LinkedFactoryName = linkedFactoryName;
        }

        /// <summary> Initializes a new instance of <see cref="LinkedIntegrationRuntimeContent"/>. </summary>
        /// <param name="linkedFactoryName"> The data factory name for linked integration runtime. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LinkedIntegrationRuntimeContent(string linkedFactoryName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LinkedFactoryName = linkedFactoryName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LinkedIntegrationRuntimeContent"/> for deserialization. </summary>
        internal LinkedIntegrationRuntimeContent()
        {
        }

        /// <summary> The data factory name for linked integration runtime. </summary>
        public string LinkedFactoryName { get; }
    }
}
