// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The result of the last integration runtime node update. </summary>
    public readonly partial struct IntegrationRuntimeUpdateResult : IEquatable<IntegrationRuntimeUpdateResult>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeUpdateResult"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationRuntimeUpdateResult(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SucceedValue = "Succeed";
        private const string FailValue = "Fail";

        /// <summary> None. </summary>
        public static IntegrationRuntimeUpdateResult None { get; } = new IntegrationRuntimeUpdateResult(NoneValue);
        /// <summary> Succeed. </summary>
        public static IntegrationRuntimeUpdateResult Succeed { get; } = new IntegrationRuntimeUpdateResult(SucceedValue);
        /// <summary> Fail. </summary>
        public static IntegrationRuntimeUpdateResult Fail { get; } = new IntegrationRuntimeUpdateResult(FailValue);
        /// <summary> Determines if two <see cref="IntegrationRuntimeUpdateResult"/> values are the same. </summary>
        public static bool operator ==(IntegrationRuntimeUpdateResult left, IntegrationRuntimeUpdateResult right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationRuntimeUpdateResult"/> values are not the same. </summary>
        public static bool operator !=(IntegrationRuntimeUpdateResult left, IntegrationRuntimeUpdateResult right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationRuntimeUpdateResult"/>. </summary>
        public static implicit operator IntegrationRuntimeUpdateResult(string value) => new IntegrationRuntimeUpdateResult(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationRuntimeUpdateResult other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationRuntimeUpdateResult other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
