// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Data proxy properties for a managed dedicated integration runtime. </summary>
    public partial class IntegrationRuntimeDataProxyProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeDataProxyProperties"/>. </summary>
        public IntegrationRuntimeDataProxyProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeDataProxyProperties"/>. </summary>
        /// <param name="connectVia"> The self-hosted integration runtime reference. </param>
        /// <param name="stagingLinkedService"> The staging linked service reference. </param>
        /// <param name="path"> The path to contain the staged data in the Blob storage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationRuntimeDataProxyProperties(EntityReference connectVia, EntityReference stagingLinkedService, string path, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConnectVia = connectVia;
            StagingLinkedService = stagingLinkedService;
            Path = path;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The self-hosted integration runtime reference. </summary>
        public EntityReference ConnectVia { get; set; }
        /// <summary> The staging linked service reference. </summary>
        public EntityReference StagingLinkedService { get; set; }
        /// <summary> The path to contain the staged data in the Blob storage. </summary>
        public string Path { get; set; }
    }
}
