// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Hubspot Service linked service. </summary>
    public partial class HubspotLinkedService : DataFactoryLinkedServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="HubspotLinkedService"/>. </summary>
        /// <param name="clientId"> The client ID associated with your Hubspot application. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientId"/> is null. </exception>
        public HubspotLinkedService(DataFactoryElement<string> clientId)
        {
            Argument.AssertNotNull(clientId, nameof(clientId));

            ClientId = clientId;
            LinkedServiceType = "Hubspot";
        }

        /// <summary> Initializes a new instance of <see cref="HubspotLinkedService"/>. </summary>
        /// <param name="linkedServiceType"> Type of linked service. </param>
        /// <param name="linkedServiceVersion"> Version of the linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="clientId"> The client ID associated with your Hubspot application. </param>
        /// <param name="clientSecret"> The client secret associated with your Hubspot application. </param>
        /// <param name="accessToken"> The access token obtained when initially authenticating your OAuth integration. </param>
        /// <param name="refreshToken"> The refresh token obtained when initially authenticating your OAuth integration. </param>
        /// <param name="useEncryptedEndpoints"> Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. </param>
        /// <param name="useHostVerification"> Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. </param>
        /// <param name="usePeerVerification"> Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </param>
        internal HubspotLinkedService(string linkedServiceType, string linkedServiceVersion, IntegrationRuntimeReference connectVia, string description, IDictionary<string, EntityParameterSpecification> parameters, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> clientId, DataFactorySecret clientSecret, DataFactorySecret accessToken, DataFactorySecret refreshToken, DataFactoryElement<bool> useEncryptedEndpoints, DataFactoryElement<bool> useHostVerification, DataFactoryElement<bool> usePeerVerification, string encryptedCredential) : base(linkedServiceType, linkedServiceVersion, connectVia, description, parameters, annotations, additionalProperties)
        {
            ClientId = clientId;
            ClientSecret = clientSecret;
            AccessToken = accessToken;
            RefreshToken = refreshToken;
            UseEncryptedEndpoints = useEncryptedEndpoints;
            UseHostVerification = useHostVerification;
            UsePeerVerification = usePeerVerification;
            EncryptedCredential = encryptedCredential;
            LinkedServiceType = linkedServiceType ?? "Hubspot";
        }

        /// <summary> Initializes a new instance of <see cref="HubspotLinkedService"/> for deserialization. </summary>
        internal HubspotLinkedService()
        {
        }

        /// <summary> The client ID associated with your Hubspot application. </summary>
        public DataFactoryElement<string> ClientId { get; set; }
        /// <summary> The client secret associated with your Hubspot application. </summary>
        public DataFactorySecret ClientSecret { get; set; }
        /// <summary> The access token obtained when initially authenticating your OAuth integration. </summary>
        public DataFactorySecret AccessToken { get; set; }
        /// <summary> The refresh token obtained when initially authenticating your OAuth integration. </summary>
        public DataFactorySecret RefreshToken { get; set; }
        /// <summary> Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. </summary>
        public DataFactoryElement<bool> UseEncryptedEndpoints { get; set; }
        /// <summary> Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true. </summary>
        public DataFactoryElement<bool> UseHostVerification { get; set; }
        /// <summary> Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. </summary>
        public DataFactoryElement<bool> UsePeerVerification { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </summary>
        public string EncryptedCredential { get; set; }
    }
}
