// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The type of Hive server. </summary>
    public readonly partial struct HiveServerType : IEquatable<HiveServerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HiveServerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HiveServerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HiveServer1Value = "HiveServer1";
        private const string HiveServer2Value = "HiveServer2";
        private const string HiveThriftServerValue = "HiveThriftServer";

        /// <summary> HiveServer1. </summary>
        public static HiveServerType HiveServer1 { get; } = new HiveServerType(HiveServer1Value);
        /// <summary> HiveServer2. </summary>
        public static HiveServerType HiveServer2 { get; } = new HiveServerType(HiveServer2Value);
        /// <summary> HiveThriftServer. </summary>
        public static HiveServerType HiveThriftServer { get; } = new HiveServerType(HiveThriftServerValue);
        /// <summary> Determines if two <see cref="HiveServerType"/> values are the same. </summary>
        public static bool operator ==(HiveServerType left, HiveServerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HiveServerType"/> values are not the same. </summary>
        public static bool operator !=(HiveServerType left, HiveServerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HiveServerType"/>. </summary>
        public static implicit operator HiveServerType(string value) => new HiveServerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HiveServerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HiveServerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
