// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> HDInsight linked service. </summary>
    public partial class HDInsightLinkedService : DataFactoryLinkedServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="HDInsightLinkedService"/>. </summary>
        /// <param name="clusterUri"> HDInsight cluster URI. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clusterUri"/> is null. </exception>
        public HDInsightLinkedService(DataFactoryElement<string> clusterUri)
        {
            Argument.AssertNotNull(clusterUri, nameof(clusterUri));

            ClusterUri = clusterUri;
            LinkedServiceType = "HDInsight";
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightLinkedService"/>. </summary>
        /// <param name="linkedServiceType"> Type of linked service. </param>
        /// <param name="linkedServiceVersion"> Version of the linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="clusterUri"> HDInsight cluster URI. Type: string (or Expression with resultType string). </param>
        /// <param name="userName"> HDInsight cluster user name. Type: string (or Expression with resultType string). </param>
        /// <param name="password"> HDInsight cluster password. </param>
        /// <param name="linkedServiceName"> The Azure Storage linked service reference. </param>
        /// <param name="hcatalogLinkedServiceName"> A reference to the Azure SQL linked service that points to the HCatalog database. </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </param>
        /// <param name="isEspEnabled"> Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean. </param>
        /// <param name="fileSystem"> Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string). </param>
        internal HDInsightLinkedService(string linkedServiceType, string linkedServiceVersion, IntegrationRuntimeReference connectVia, string description, IDictionary<string, EntityParameterSpecification> parameters, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> clusterUri, DataFactoryElement<string> userName, DataFactorySecret password, DataFactoryLinkedServiceReference linkedServiceName, DataFactoryLinkedServiceReference hcatalogLinkedServiceName, string encryptedCredential, DataFactoryElement<bool> isEspEnabled, DataFactoryElement<string> fileSystem) : base(linkedServiceType, linkedServiceVersion, connectVia, description, parameters, annotations, additionalProperties)
        {
            ClusterUri = clusterUri;
            UserName = userName;
            Password = password;
            LinkedServiceName = linkedServiceName;
            HcatalogLinkedServiceName = hcatalogLinkedServiceName;
            EncryptedCredential = encryptedCredential;
            IsEspEnabled = isEspEnabled;
            FileSystem = fileSystem;
            LinkedServiceType = linkedServiceType ?? "HDInsight";
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightLinkedService"/> for deserialization. </summary>
        internal HDInsightLinkedService()
        {
        }

        /// <summary> HDInsight cluster URI. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> ClusterUri { get; set; }
        /// <summary> HDInsight cluster user name. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> UserName { get; set; }
        /// <summary> HDInsight cluster password. </summary>
        public DataFactorySecret Password { get; set; }
        /// <summary> The Azure Storage linked service reference. </summary>
        public DataFactoryLinkedServiceReference LinkedServiceName { get; set; }
        /// <summary> A reference to the Azure SQL linked service that points to the HCatalog database. </summary>
        public DataFactoryLinkedServiceReference HcatalogLinkedServiceName { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string. </summary>
        public string EncryptedCredential { get; set; }
        /// <summary> Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean. </summary>
        public DataFactoryElement<bool> IsEspEnabled { get; set; }
        /// <summary> Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> FileSystem { get; set; }
    }
}
